/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage.man;

import edu.colorado.phet.batteryvoltage.Battery;
import edu.colorado.phet.batteryvoltage.ParticleMoveListener;
import edu.colorado.phet.batteryvoltage.common.phys2d.Particle;
import edu.colorado.phet.batteryvoltage.common.phys2d.PropagatingParticle;
import edu.colorado.phet.batteryvoltage.common.phys2d.System2D;
import edu.colorado.phet.batteryvoltage.man.VoltMan;
import edu.colorado.phet.batteryvoltage.man.voltListeners.VoltageListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Director
implements ParticleMoveListener,
VoltageListener {
    Vector carried;
    Vector targeted;
    int setVolts;
    Vector men;
    System2D sys;
    double middle;
    Hashtable sideTags = new Hashtable();

    public Director(System2D system2D, Vector vector, Vector vector2, int n, double d) {
        this.middle = d;
        this.sys = system2D;
        this.men = new Vector();
        this.setVolts = n;
        this.carried = vector;
        this.targeted = vector2;
    }

    public void determineTag(Particle particle) {
        if (particle.getPosition().getX() > this.middle) {
            this.putTag(particle, true);
        } else {
            this.putTag(particle, false);
        }
    }

    public int getTagCount(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        Enumeration enumeration = this.sideTags.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!bl2.equals(this.sideTags.get(k))) continue;
            ++n;
        }
        return n;
    }

    public void initTags(Particle[] particleArray) {
        for (int i = 0; i < particleArray.length; ++i) {
            this.determineTag(particleArray[i]);
        }
    }

    public void putTag(Particle particle, boolean bl) {
        this.sideTags.put(particle, new Boolean(bl));
    }

    public void addVoltMan(VoltMan voltMan) {
        this.men.add(voltMan);
        voltMan.goHomeAndStayThere();
    }

    public int numMen() {
        return this.men.size();
    }

    public VoltMan manAt(int n) {
        return (VoltMan)this.men.get(n);
    }

    public void particleMoved(Battery battery, Particle particle) {
        if (particle != null) {
            this.determineTag(particle);
        }
        this.voltageChanged(this.setVolts, battery);
    }

    public void voltageChanged(int n, Battery battery) {
        boolean bl;
        int n2;
        this.setVolts = n;
        int n3 = this.getTagCount(true);
        int n4 = n3;
        int n5 = n4 - (n2 = this.setVolts);
        if (n5 == 0) {
            return;
        }
        boolean bl2 = bl = n5 < 0;
        if (bl) {
            int n6 = Math.abs(n5);
            int n7 = 0;
            for (int i = 0; i < this.numMen(); ++i) {
                if (!this.manAt(i).isAvailable()) continue;
                PropagatingParticle propagatingParticle = this.nextLeftParticle(0);
                this.targeted.add(propagatingParticle);
                if (propagatingParticle == null) break;
                this.manAt(i).carryElectronRight(propagatingParticle);
                this.putTag(propagatingParticle, true);
                if (++n7 < n6) {
                    continue;
                }
                break;
            }
        } else {
            int n8 = Math.abs(n5);
            int n9 = 0;
            for (int i = 0; i < this.numMen(); ++i) {
                if (!this.manAt(i).isAvailable()) continue;
                PropagatingParticle propagatingParticle = this.nextRightParticle(0);
                this.targeted.add(propagatingParticle);
                if (propagatingParticle == null) break;
                this.manAt(i).carryElectronLeft(propagatingParticle);
                this.putTag(propagatingParticle, false);
                if (++n9 < n8) {
                    continue;
                }
                break;
            }
        }
    }

    public PropagatingParticle nextLeftParticle(int n) {
        for (int i = n; i < this.sys.numParticles(); ++i) {
            PropagatingParticle propagatingParticle = (PropagatingParticle)this.sys.particleAt(i);
            if (this.carried.contains(propagatingParticle) || this.targeted.contains(propagatingParticle) || !(propagatingParticle.getPosition().getX() < this.middle)) continue;
            return propagatingParticle;
        }
        return null;
    }

    public PropagatingParticle nextRightParticle(int n) {
        for (int i = n; i < this.sys.numParticles(); ++i) {
            PropagatingParticle propagatingParticle = (PropagatingParticle)this.sys.particleAt(i);
            if (this.carried.contains(propagatingParticle) || this.targeted.contains(propagatingParticle) || !(propagatingParticle.getPosition().getX() > this.middle)) continue;
            return propagatingParticle;
        }
        return null;
    }
}

