/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage.common.electron.laws;

import edu.colorado.phet.batteryvoltage.common.electron.core.ParticleList;
import edu.colorado.phet.batteryvoltage.common.electron.laws.ForceLaw;
import edu.colorado.phet.batteryvoltage.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryvoltage.common.phys2d.Particle;
import edu.colorado.phet.batteryvoltage.common.phys2d.Propagator;

public class ForceLawPropagator
extends ParticleList
implements Propagator {
    ForceLaw law;

    public ForceLawPropagator(ForceLaw forceLaw) {
        this(new Particle[0], forceLaw);
    }

    public ForceLawPropagator(Particle[] particleArray, ForceLaw forceLaw) {
        this.addAll(particleArray);
        this.law = forceLaw;
    }

    public DoublePoint getForce(Particle particle) {
        DoublePoint doublePoint = new DoublePoint();
        for (int i = 0; i < this.numParticles(); ++i) {
            Particle particle2 = this.particleAt(i);
            if (particle2 == particle) continue;
            doublePoint = doublePoint.add(this.law.getForce(particle2, particle));
        }
        return doublePoint;
    }

    public void propagate(double d, Particle particle) {
        DoublePoint doublePoint = this.getForce(particle);
        double d2 = particle.getMass();
        DoublePoint doublePoint2 = doublePoint.multiply(1.0 / d2);
        DoublePoint doublePoint3 = particle.getAcceleration();
        DoublePoint doublePoint4 = doublePoint3.add(doublePoint2);
        particle.setAcceleration(doublePoint4);
    }
}

